/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.wand;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.mc_utils.WireRenderingHelper;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalUtils;
import qouteall.imm_ptl.core.portal.animation.TimingFunction;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.imm_ptl.core.render.TransformationManager;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.peripheral.ImmPtlCustomOverlay;
import qouteall.imm_ptl.peripheral.wand.WandUtil;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.api.McRemoteProcedureCall;
import qouteall.q_misc_util.my_util.AARotation;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.WithDim;
import qouteall.q_misc_util.my_util.animation.Animated;
import qouteall.q_misc_util.my_util.animation.RenderedPoint;

@OnlyIn(value=Dist.CLIENT)
public class ClientPortalWandPortalCopy {
    @NotNull
    private static Status status = new Status_SelectPortal();
    public static Animated<RenderedPoint> cursor = new Animated<RenderedPoint>(Animated.RENDERED_POINT_TYPE_INFO, () -> RenderStates.renderStartNanoTime, TimingFunction.sine::mapProgress, RenderedPoint.EMPTY);
    public static Animated<UnilateralPortalState> selection = new Animated<Object>(UnilateralPortalState.ANIMATION_TYPE_INFO, () -> RenderStates.renderStartNanoTime, TimingFunction.sine::mapProgress, null);
    public static Animated<DQuaternion> placementOrientation = new Animated<DQuaternion>(Animated.QUATERNION_TYPE_INFO, () -> RenderStates.renderStartNanoTime, TimingFunction.sine::mapProgress, DQuaternion.identity);
    public static Animated<Double> placementOffsetLen = new Animated<Double>(Animated.DOUBLE_TYPE_INFO, () -> RenderStates.renderStartNanoTime, TimingFunction.sine::mapProgress, 0.0);
    private static final int colorOfCursor = -16515844;
    private static final int colorOfSelection1 = -11337838;
    private static final int colorOfSelection2 = -224451;
    private static final int colorOfPendingPlacement1 = -16711681;
    private static final int colorOfPendingPlacement2 = -2339841;

    public static void reset() {
        status = new Status_SelectPortal();
        cursor.clearTarget();
        selection.clearTarget();
        placementOrientation.clearTarget();
        placementOffsetLen.clearTarget();
    }

    public static void updateDisplay() {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        Vec3 eyePos = player.m_20299_(RenderStates.getPartialTick());
        Vec3 viewVec = player.m_20154_();
        Status status = ClientPortalWandPortalCopy.status;
        if (status instanceof Status_SelectPortal) {
            Status_SelectPortal statusSelectPortal = (Status_SelectPortal)status;
            cursor.clearTarget();
            rayTraceResult = PortalUtils.lenientRayTracePortals(player.m_9236_(), eyePos, eyePos.m_82549_(viewVec.m_82490_(64.0)), false, p -> true, 1.0).orElse(null);
            if (rayTraceResult != null) {
                Portal portal = (Portal)rayTraceResult.getFirst();
                selection.setTarget(portal.getThisSideState(), Helper.secondToNano(0.5));
                statusSelectPortal.selectedPortalId = portal.m_20148_();
                ImmPtlCustomOverlay.putText((Component)Component.m_237110_((String)"imm_ptl.wand.copy.prompt.copy_or_cut", (Object[])new Object[]{Minecraft.m_91087_().f_91066_.f_92095_.m_90863_(), Minecraft.m_91087_().f_91066_.f_92096_.m_90863_()}));
            } else {
                selection.clearTarget();
                statusSelectPortal.selectedPortalId = null;
                ImmPtlCustomOverlay.putText((Component)Component.m_237115_((String)"imm_ptl.wand.copy.prompt.select_portal"));
            }
        } else {
            rayTraceResult = ClientPortalWandPortalCopy.status;
            if (rayTraceResult instanceof Status_PlacingPortal) {
                UnilateralPortalState placement;
                Vec3 preCursorPos;
                Status_PlacingPortal statusPlacingPortal = (Status_PlacingPortal)rayTraceResult;
                selection.clearTarget();
                HitResult hitResult = player.m_19907_(64.0, RenderStates.getPartialTick(), false);
                int alignment = IPConfig.getConfig().portalWandCursorAlignment;
                if (hitResult.m_6662_() == HitResult.Type.BLOCK && hitResult instanceof BlockHitResult) {
                    BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                    preCursorPos = blockHitResult.m_82450_();
                } else {
                    preCursorPos = eyePos.m_82549_(viewVec.m_82490_(5.0));
                }
                Vec3 cursorPointing = WandUtil.alignOnBlocks(player.m_9236_(), preCursorPos, alignment);
                cursor.setTarget(new RenderedPoint(new WithDim<Vec3>((ResourceKey<Level>)player.m_9236_().m_46472_(), cursorPointing), 1.0), Helper.secondToNano(0.5));
                DQuaternion camRotInverse = TransformationManager.getPlayerCameraRotation().getConjugated();
                AARotation orientationRot = Arrays.stream(AARotation.values()).min(Comparator.comparingDouble(r -> DQuaternion.distance(r.quaternion, camRotInverse))).orElseThrow();
                DQuaternion orientation = orientationRot.quaternion;
                PlacementRequirement req = statusPlacingPortal.placementRequirement;
                boolean isFacingUpOrDown = player.m_146909_() > 45.0f || player.m_146909_() < -45.0f;
                double offsetLen = isFacingUpOrDown ? 0.0 : req.height() / 2.0;
                Vec3 offset = orientation.rotate(new Vec3(0.0, offsetLen, 0.0));
                Vec3 placementOrigin = cursorPointing.m_82549_(offset);
                statusPlacingPortal.pendingPlacement = placement = new UnilateralPortalState((ResourceKey<Level>)player.m_9236_().m_46472_(), placementOrigin, orientation, req.width(), req.height());
                placementOrientation.setTarget(orientation, Helper.secondToNano(0.5));
                placementOffsetLen.setTarget(offsetLen, Helper.secondToNano(0.5));
                ImmPtlCustomOverlay.putText((Component)Component.m_237110_((String)"imm_ptl.wand.copy.prompt.place_portal", (Object[])new Object[]{Minecraft.m_91087_().f_91066_.f_92095_.m_90863_(), Minecraft.m_91087_().f_91066_.f_92096_.m_90863_()}));
            } else {
                throw new RuntimeException();
            }
        }
    }

    public static void onLeftClick() {
        Status status = ClientPortalWandPortalCopy.status;
        if (status instanceof Status_SelectPortal) {
            Portal portal;
            Status_SelectPortal statusSelectPortal = (Status_SelectPortal)status;
            if (statusSelectPortal.selectedPortalId != null && (portal = WandUtil.getClientPortalByUUID(statusSelectPortal.selectedPortalId)) != null) {
                ClientPortalWandPortalCopy.status = new Status_PlacingPortal(new PlacementRequirement(portal.width, portal.height), true);
                McRemoteProcedureCall.tellServerToInvoke("qouteall.imm_ptl.peripheral.wand.PortalWandInteraction.RemoteCallables.copyCutPortal", statusSelectPortal.selectedPortalId, true);
            }
        } else {
            status = ClientPortalWandPortalCopy.status;
            if (status instanceof Status_PlacingPortal) {
                Status_PlacingPortal statusPlacingPortal = (Status_PlacingPortal)status;
                McRemoteProcedureCall.tellServerToInvoke("qouteall.imm_ptl.peripheral.wand.PortalWandInteraction.RemoteCallables.clearPortalClipboard", new Object[0]);
                ClientPortalWandPortalCopy.status = new Status_SelectPortal();
            }
        }
    }

    public static void onRightClick() {
        Status status = ClientPortalWandPortalCopy.status;
        if (status instanceof Status_SelectPortal) {
            Portal portal;
            Status_SelectPortal statusSelectPortal = (Status_SelectPortal)status;
            if (statusSelectPortal.selectedPortalId != null && (portal = WandUtil.getClientPortalByUUID(statusSelectPortal.selectedPortalId)) != null) {
                ClientPortalWandPortalCopy.status = new Status_PlacingPortal(new PlacementRequirement(portal.width, portal.height), false);
                McRemoteProcedureCall.tellServerToInvoke("qouteall.imm_ptl.peripheral.wand.PortalWandInteraction.RemoteCallables.copyCutPortal", statusSelectPortal.selectedPortalId, false);
            }
        } else {
            status = ClientPortalWandPortalCopy.status;
            if (status instanceof Status_PlacingPortal) {
                Status_PlacingPortal statusPlacingPortal = (Status_PlacingPortal)status;
                if (statusPlacingPortal.pendingPlacement != null) {
                    McRemoteProcedureCall.tellServerToInvoke("qouteall.imm_ptl.peripheral.wand.PortalWandInteraction.RemoteCallables.confirmCopyCut", statusPlacingPortal.pendingPlacement.position(), statusPlacingPortal.pendingPlacement.orientation());
                    ClientPortalWandPortalCopy.status = new Status_SelectPortal();
                }
            }
        }
    }

    public static void render(PoseStack matrixStack, MultiBufferSource.BufferSource bufferSource, double camX, double camY, double camZ) {
        Status status;
        UnilateralPortalState rect;
        WithDim<Vec3> posWithDim;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (PortalRendering.isRendering()) {
            return;
        }
        ResourceKey currDim = player.m_9236_().m_46472_();
        Vec3 cameraPos = new Vec3(camX, camY, camZ);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110504_());
        Vec3 cursorPos = null;
        RenderedPoint currentCursor = cursor.getCurrent();
        if (currentCursor != null && (posWithDim = currentCursor.pos()) != null && posWithDim.dimension() == currDim) {
            cursorPos = posWithDim.value();
        }
        if (cursorPos != null) {
            WireRenderingHelper.renderSmallCubeFrame(vertexConsumer, cameraPos, cursorPos, -16515844, cursor.getCurrent().scale(), matrixStack);
        }
        if ((rect = selection.getCurrent()) != null && rect.dimension() == currDim) {
            WireRenderingHelper.renderRectFrameFlow(matrixStack, cameraPos, vertexConsumer, rect, -11337838, -224451);
        }
        if ((status = ClientPortalWandPortalCopy.status) instanceof Status_PlacingPortal) {
            Status_PlacingPortal statusPlacingPortal = (Status_PlacingPortal)status;
            DQuaternion orientation = placementOrientation.getCurrent();
            Double offsetLen = placementOffsetLen.getCurrent();
            Validate.isTrue((orientation != null ? 1 : 0) != 0);
            Validate.isTrue((offsetLen != null ? 1 : 0) != 0);
            Vec3 offset = orientation.rotate(new Vec3(0.0, offsetLen.doubleValue(), 0.0));
            if (cursorPos != null) {
                PlacementRequirement req = statusPlacingPortal.placementRequirement;
                UnilateralPortalState placement = new UnilateralPortalState((ResourceKey<Level>)currDim, cursorPos.m_82549_(offset), orientation, req.width(), req.height());
                WireRenderingHelper.renderRectFrameFlow(matrixStack, cameraPos, vertexConsumer, placement, -16711681, -2339841);
            }
        }
    }

    private static final class Status_SelectPortal
    implements Status {
        @Nullable
        public UUID selectedPortalId;

        private Status_SelectPortal() {
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static interface Status {
    }

    private static final class Status_PlacingPortal
    implements Status {
        @NotNull
        public final PlacementRequirement placementRequirement;
        public final boolean isCut;
        @Nullable
        public UnilateralPortalState pendingPlacement;

        private Status_PlacingPortal(@NotNull PlacementRequirement placementRequirement, boolean isCut) {
            this.placementRequirement = placementRequirement;
            this.isCut = isCut;
        }
    }

    public record PlacementRequirement(double width, double height) {
    }
}

